//=============================================================================

/*:
 * @plugindesc 逃走コマンド実行前に確認ダイアログを出します
 * 
 * @author LefTonbo
 *
 */
 
//=============================================================================

var Imported = Imported || {};
Imported.LP_BattleEscapeConfirm = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// Scene_Battle
//=============================================================================

var _Scene_Battle_createAllWindows = Scene_Battle.prototype.createAllWindows;
Scene_Battle.prototype.createAllWindows = function() {
  _Scene_Battle_createAllWindows.call(this);
  this.createEscapeConfirmWindow();
}

Scene_Battle.prototype.createEscapeConfirmWindow = function() {
  this._escapeConfirmWindow = new Window_EscapeConfirm();
  this._escapeConfirmWindow.setHandler('confirm', this.commandEscapeConfirm.bind(this));
  this._escapeConfirmWindow.setHandler('cancel', this.commandEscapeCancel.bind(this));
  this._escapeConfirmWindow.deselect();
  this.addWindow(this._escapeConfirmWindow);
};

var _Scene_Battle_commandEscape = Scene_Battle.prototype.commandEscape;
Scene_Battle.prototype.commandEscape = function() {
  if ($gameTroop.turnCount() < 1) {
    return _Scene_Battle_commandEscape.call(this);
  }
  this._escapeConfirmWindow.setup();
};

Scene_Battle.prototype.commandEscapeConfirm = function() {
  this._escapeConfirmWindow.close();
  _Scene_Battle_commandEscape.call(this);
};

Scene_Battle.prototype.commandEscapeCancel = function() {
  this._escapeConfirmWindow.close();
  this._partyCommandWindow.activate();
};

var _Scene_Battle_isAnyInputWindowActive = Scene_Battle.prototype.isAnyInputWindowActive;
Scene_Battle.prototype.isAnyInputWindowActive = function() {
  if (_Scene_Battle_isAnyInputWindowActive.call(this)) {
    return true;
  }
  return this._escapeConfirmWindow.active;
};

//=============================================================================
// Scene_Battle
//=============================================================================

function Window_EscapeConfirm() {
  this.initialize.apply(this, arguments);
}

Window_EscapeConfirm.prototype = Object.create(Window_Command.prototype);
Window_EscapeConfirm.prototype.constructor = Window_EscapeConfirm;

Window_EscapeConfirm.prototype.initialize = function(numLines) {
  this._text = '戦闘を諦めて逃走しますか？';
  var height = this.fittingHeight(numLines || 3);
  Window_Command.prototype.initialize.call(this, 0, 0, 32, height);
  this.width = this.textWidthEx(this._text) + this.standardPadding() * 2;
  this.x = (Graphics.boxWidth - this.width) / 2;
  this.y = (Graphics.boxHeight - this.height) / 2;
  this.openness = 0;
  this.deactivate();
};

Window_EscapeConfirm.prototype.makeCommandList = function() {
  this.addCommand(TextManager.escape, 'confirm');
  this.addCommand(TextManager.fight, 'cancel');
};

Window_EscapeConfirm.prototype.textWidthEx = function(text) {
  return this.drawTextEx(text, 0, this.contents.height);
};

Window_EscapeConfirm.prototype.itemTextAlign = function() {
  return 'center';
};

Window_EscapeConfirm.prototype.windowHeight = function() {
  return this.fittingHeight(3);
};

Window_EscapeConfirm.prototype.itemRect = function(index) {
  var rect = Window_Selectable.prototype.itemRect.call(this, index);
  rect.y += this.lineHeight();
  return rect;
};

Window_EscapeConfirm.prototype.setup = function() {
  this.clearCommandList();
  this.makeCommandList();
  this.refresh();
  this.drawTextEx(this._text, this.textPadding(), 0);
  this.select(1);
  this.activate();
  this.open();
};

Window_EscapeConfirm.prototype.playOkSound = function() {
  if (this.currentSymbol() === 'cancel') {
    SoundManager.playCancel();
  } else {
    SoundManager.playOk();
  }
};

//=============================================================================

})();

// EOF